import logging
import sys
import os
import json
import subprocess
import shutil
from pathlib import Path

def parent_parent_dir_finder(name, p_path=Path(os.path.abspath(__file__))):
    return str(p_path.parent.absolute().parent.parent) + name

def write_json(self, **kwargs):
    print("Args passed are: {0}".format(kwargs))
    self.update(**kwargs)
    self['proxy'] = kwargs['proxy'] if kwargs['proxy'] else None
    self['method'] = 'syslog' 
    # self['query'] = f"{kwargs['query']} LIMIT 200 OFFSET 1" if "LIMIT" not in kwargs['query'] and "OFFSET" not in kwargs['query'] else kwargs['query']
    self['query'] = kwargs['query'] if kwargs['query'] else None
    if 'https://' not in self['tenant'] : self['tenant'] = 'https://{tenant}'.format(**kwargs)
    if self['proxy'] != None: 
        if 'http://' not in self['proxy'] : self['proxy'] = 'http://{proxy}'.format(**kwargs)
    try:
        with open(parent_parent_dir_finder('/delinea_syslog/util/conf/config.json'), 'w') as json_file:
            return json.dump(self, json_file, sort_keys=True, indent=4)
    except Exception as e:
        print(f"Cannot write to file. Exception is: {e}")
    return {}

def set_up_dir(r_dir='/opt', **kwargs):
    try:
        print("Writing config file now.....")
        write_json({}, **kwargs)
        #print(f"Need to create dirs and copy files over. Making it in {r_dir}.")
        #Path(f"{r_dir}/delinea/pas/reporting_tool").mkdir(parents=True, exist_ok=True)#, mode=0o600)
        #print("Copying files over now...")
        #shutil.copytree(f'{parent_parent_dir_finder("/util")}', f"{r_dir}/delinea/pas/reporting_tool/util", dirs_exist_ok=True)
        os.chmod(f"{r_dir}/delinea/pas/reporting_tool", mode=0o600)
        #shutil.copy(f'{parent_parent_dir_finder(str())}/delinea_syslog_writer.py', f"{r_dir}/delinea/pas/reporting_tool")
        os.chmod(f"{r_dir}/delinea/pas/reporting_tool//delinea_syslog/delinea_syslog_writer.py", mode=0o500)
        return True
    except Exception as e:
        print(f"Cannot make standard dir. Exiting. Exception: {e}")
        return False

def install_deps(*packages, offline=bool()):
    p_list = ' '.join(packages)
    if not offline:
        try:
            print("Force installing dependencies from the internet. Will stdout.")
            subprocess.check_call(f'sudo /usr/bin/python3 /usr/bin/pip3 install {p_list}',\
            executable='/bin/bash', shell=True, stderr=subprocess.STDOUT)
            return True
        except Exception as e:
            print(f"Issue with trying to execute online install. Exceptions is {e}")
            return False
    else:
        try:
            print("Force installing dependencies offline. Will stdout.")
            os.chdir(f'{parent_parent_dir_finder("/setup/offline_dep_libs")}/')
            for f in os.listdir(f'{parent_parent_dir_finder("/setup/offline_dep_libs")}/'):
                subprocess.check_call(f"sudo /usr/bin/python3 /usr/bin/pip3 install {f} --no-index --find-links '.'",\
            executable='/bin/bash', shell=True, stderr=subprocess.STDOUT)
            return True
        except Exception as e:
            print(f"Issue with trying to execute offline install. Exceptions is {e}")
            return False

def delinea_runner(will_install, offline, **kwargs):
    print(will_install)
    if will_install:
        print("Will do install")
        install_deps("centrify.dmc", "requests", "cachetools", offline=offline)    
    del kwargs['install_dependencies']
    del kwargs["offline_install"]
    if not set_up_dir(**kwargs):
        sys.exit("Couldn't make dir so wont continue")