#! /usr/bin/python3
import argparse
import logging as log
from utils.setup_utils import delinea_runner

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Helps set up the Delinea syslog writer.")
    parser.add_argument('-s','--scope', type=str, required=True, default=None, help= "Scope of the enrolled agent.")
    parser.add_argument('-f','--frequency', type=int, required=True, default=None, help= "Frequency of query. Must be above 5 and below 60.")
    parser.add_argument('-t','--tenant', type=str, required=True, default=None, help= 'Tenant; i.e. ABC0123.my.centrify.net')
    parser.add_argument('-q','--query', type=str, required=False, default=None, help= """Query to use. i.e. SELECT * FROM Event WHERE WhenOccurred > DateFunc('now','-00:15') ORDER BY WhenOccurred.\nit would be smart to have it have an offest. ex: 15 min cron job, but query is DateFunc('now','-00:16')""")
    parser.add_argument('-dep','--install-dependencies', action='store_true', help= "Will brute force install the dependencies. Either online or offline. Note, offline will use the bundled packages")
    parser.add_argument('-off','--offline-install', action='store_true', help= "Will install dependencies that are local from wheel files")
    parser.add_argument('-p','--proxy', type=str, required=False, help= "Web IP address of proxy and port, if proxy (i.e. 127.0.0.1:8080)")
    args = parser.parse_args()
    arg_dict = vars(args)

delinea_runner(will_install=arg_dict["install_dependencies"], offline=arg_dict['offline_install'], **arg_dict)