import os
import sys
import csv
import json
import syslog
import logging
import requests
from pathlib import Path
from cachetools import TTLCache
import subprocess
from .rest import query
from .file_utils import init_file_utils, method_sanity_check, frequency_integer_guard, time_formatter_and_data_writer
from dmc import gettoken
import traceback

f = init_file_utils()['loaded']

if not method_sanity_check("syslog", method=f.get('method', 'syslog')) or not \
    frequency_integer_guard(f.get('frequency'), 5, 60):
    syslog.syslog(syslog.LOG_ERR, 'Cannot continue as there is an issue with the method selection or frequency value.')
    exit()
# Old way of getting the exe path
def find_exe_path(p_path=Path(os.path.abspath(__file__)), name='/delinea_syslog_writer.py'):
    try:
        return str(p_path.parent.absolute().parent) + name
    except OSError as exc:
        return exc

def setup_auth_headers(**kwargs):
    syslog.syslog("Using DMC as authentication to get information.")
    syslog.syslog("DMC scope is: {scope}".format(**kwargs))
    return {
        "X-CENTRIFY-NATIVE-CLIENT": 'true',
        'X-CFY-SRC' : 'python',
        "Authorization": f'Bearer {gettoken(kwargs.get("scope", "*"))}'
    }

def ten_info(**kwargs):
    # Never make the TTL over 60. Issues can occur with stale token data
    cache = TTLCache(maxsize=5, ttl=60)
    syslog.syslog("Building the cache...")
    try:
        cache['header'] = setup_auth_headers(**kwargs)
        cache['tenant'] = kwargs['tenant']
        cache['proxy'] = kwargs['proxy'] if kwargs['proxy'] else None
        cache['sql'] = kwargs['query'] if kwargs['query'] else None
        syslog.syslog("Built the cache.")
    except Exception as e:
        syslog.syslog(syslog.LOG_ERR, f"Issue with building cache. Exception is: {e}, Exiting")
        return False
    return cache

def check_cron_job_existence(path):
    syslog.syslog("Checking existence of other cronjob(s) to avoid collision")
    try:
        subprocess.check_call(f"""crontab -l | grep '{path}' """, shell=True, executable='/bin/bash', \
            stdout=subprocess.DEVNULL, stderr=subprocess.STDOUT)
    except:
        syslog.syslog("Does not exist, making cron job")
        return True
    syslog.syslog("Does exist, skip making the job.")
    return False

def make_cron_job(freq=f.get('frequency'), path='/opt/delinea/pas/reporting_tool/delinea_syslog/delinea_syslog_writer.py', method=f.get('method'), **ignored):
    if not check_cron_job_existence(path):
        return True
    if method.upper() == 'SYSLOG':
        syslog.syslog("Using Syslog as mode of operation.")
        try:
            return subprocess.check_call(f"""((crontab -l; echo $'*/{freq} * * * * sudo /usr/bin/python3 {path}') | crontab)""",\
                executable='/bin/bash', shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.STDOUT)
        except Exception as e:
            syslog.syslog(syslog.LOG_ERR, f"Issue when trying to set crontab, exception is: {e}")
            return False
        return True

def event_writer(wanted, method=f.get('method', 'syslog')):
    if method == "syslog":
        try:
            logs = time_formatter_and_data_writer(wanted, "WhenLogged", "WhenDueBack", "StartTime", "EndTime", "WhenOccurred", "LastHealthCheck", "DiscoveredTime")
            for log in logs:
                syslog.syslog(log)
            return True
        except:
            syslog.syslog(syslog.LOG_ERR, f"Issue when trying to write data to syslog. exception is: {traceback.format_exc()}")
            return False
    elif method == "email":
        try:
            logs = time_formatter_and_data_writer(wanted, "WhenLogged", "WhenDueBack", "StartTime", "EndTime", "WhenOccurred", "LastHealthCheck", "DiscoveredTime")
            for log in logs:
                print(log)
            return True
        except Exception as e:
            syslog.syslog(syslog.LOG_ERR, f"Issue when trying to stdout data, exception is: {e}")
            return False

def exe_syslog():
    make_cron_job()
    try:
        return event_writer(query(**ten_info(**f)))
    except:
        syslog.syslog(syslog.LOG_ERR, f"Serious issue when executing syslog function. Exception is: {traceback.format_exc()}")
        return False