from datetime import datetime, timezone
import json
import re
import requests
import syslog
import traceback
from .file_utils import init_file_utils

f = init_file_utils()['loaded']

def api_request(self, call, tenant, header, proxy, **kwargs):
    self.update(**kwargs)
    try:
        syslog.syslog("Starting request...")
        syslog.syslog(f"Endpoint is: {call}")
        if proxy:
            syslog.syslog(f"Proxy config is present; address is: {proxy}")
            other_requests = requests.post(url=f'{tenant}{call}', headers=header, proxies={'https': proxy},\
                json=self).json()
        else:
            other_requests = requests.post(url=f'{tenant}{call}', headers=header,\
            json=self)
    except:
        syslog.syslog(syslog.LOG_ERR, f"Issue with request that is fatal. Exception: {traceback.format_exc()}.")
        return False
    if other_requests.status_code != 200:
        syslog.syslog(syslog.LOG_ERR, f'''Request is not good; bailing. resp code: {other_requests.status_code}, message is: {other_requests.text}''')
        exit()
    parsed_json = json.loads(json.dumps(other_requests.json()))
    if parsed_json['success'] == False:
        syslog.syslog(syslog.LOG_ERR, f'''Request may have had issues or debug is on. The response is below.

{parsed_json}''')
    syslog.syslog("Finished request")
    return parsed_json

def query(tenant, header, proxy=f.get('proxy'), query=f.get('query'), **ignored):

    # if "offset" not in query.lower() or "limit" not in query.lower():
    #     syslog.syslog(syslog.LOG_ERR, f'''Query is NOT correct. We need to limit and have offset. here is the query: {query}. Please change it.''')
    #     exit()
    
    args={
        "PageNumber":1,
        "PageSize":200,
        "Limit":200,
        }   
    
    try:
        # Fetch the current server time
        time_query = api_request({}, call="/RedRock/Query", tenant=tenant, header=header, proxy=proxy, Script='SELECT NOW();')
        if "Result" in time_query and "Results" in time_query["Result"]:
            epoch_time = str(time_query["Result"]["Results"][0]["Row"]["now"])
            match = re.search(r"/Date\((\d+)\+?\d*\)/", epoch_time)
            if match:
                epoch_time_in_seconds = int(match.group(1)) / 1000
                syslog.syslog(f"Extracted timestamp in milliseconds: {epoch_time_in_seconds}")
            else:
                syslog.syslog("Invalid timestamp format")
            server_time = datetime.fromtimestamp(epoch_time_in_seconds, tz=timezone.utc).strftime('%Y-%m-%d %H:%M:%S.%f')[:-3]
            syslog.syslog(f"Fetched server time: {server_time}")
        else:
            syslog.syslog(syslog.LOG_ERR, "Failed to fetch server time.")
            exit() 

        total_minutes = f.get('frequency') + 1
        hours = total_minutes // 60
        minutes = total_minutes % 60

        if query is None:
            query = f"Select * FROM Event WHERE WhenOccurred > DateFunc('{server_time}','-{hours:02}:{minutes:02}') ORDER BY WhenOccurred"
        else:
            query = query.replace("'now'", f"'{server_time}'") 
        
        if query.lower().count("select") > 1 or query.lower().count("from") > 1:
            syslog.syslog(syslog.LOG_ERR, f'''Too many select and from statements. Please only have one each. Here is the query: {query}. Please change it.''')
            exit()
        syslog.syslog(f"Query is: {query}") 

        # Initialize variables for pagination
        all_data = []
        page_number = 1
        total_pages = 1 

        while page_number <= total_pages:
            args["PageNumber"] = page_number
            query_result = api_request({}, call="/RedRock/Query", tenant=tenant, header=header, proxy=proxy, Script=f'{query}', args=args)
            if "Result" in query_result and "Results" in query_result["Result"]:
                results = query_result["Result"]["Results"]

                # Get total records and calculate total pages
                if page_number == 1 and len(results) > 0 and "Row" in results[0] and "_pg_page_full_count_" in results[0]["Row"]:
                    total_records = int(results[0]["Row"]["_pg_page_full_count_"])
                    total_pages = (total_records + args["PageSize"] - 1) // args["PageSize"]
                    syslog.syslog(f"Total Records: {total_records}, Total Pages: {total_pages}")

                # Process and collect data
                for result in results:
                    if isinstance(result, dict) and "Row" in result:
                        try:
                            all_data.append(dict(result["Row"]))
                        except (TypeError, KeyError) as e:
                            syslog.syslog(syslog.LOG_ERR, f"Error processing page {page_number}: {e}")
                    else:
                        syslog.syslog(f"Skipping invalid result on page {page_number}")
            else:
                syslog.syslog(syslog.LOG_ERR, f"Error fetching data for page {page_number}")
                break

            syslog.syslog(f"Completed fetching page {page_number}")
            page_number += 1

        syslog.syslog("Fetched all pages successfully.")
        return all_data

        
        # if "Result" in query and "Results" in query["Result"]:
        #     if "Row" in query["Result"]["Results"][0] and "_pg_page_full_count_" in query["Result"]["Results"][0]["Row"]:
        #         page_num = int(query["Result"]["Results"][0]["Row"]['_pg_page_full_count_'])
        #         syslog.syslog(f"Page Count: {page_num}")
        #     else:
        #         syslog.syslog("Page count not found!")
        #         page_num = 1 
        #     data = []
        #     for i in range(len(query["Result"]["Results"])):
        #         result = query["Result"]["Results"][i]
        #         syslog.syslog(f"Inspecting elements on page: [{i}]")
        #         if isinstance(result, dict) and "Row" in result:
        #             try:
        #                 data.extend([dict(result["Row"])])
        #             except (TypeError, KeyError) as e:
        #                 syslog.syslog(syslog.LOG_ERR, "Error while processing page {i}: {e}")
        #         else:
        #             syslog.syslog(f"Skipping invalid result at index {i}, not a dictionary")
        #     syslog.syslog("Collected data all data from pages")
        # return data
    except:
        syslog.syslog(syslog.LOG_ERR, f'''Error occurred when building data set, error being: 
{traceback.format_exc()}
This may be caused by data not being there or from a bad connection to tenant Please try the query in the tenant UI first and see if there are any data returned. Verifying if this is indeed the issue.
Please try the query in the tenant UI first and see if there are any data returned and check the connection''')