import syslog
import json
import os
import time

def headers_check(scope, tenant, method, query, frequency, **ignored):
    return True

def open_json(filePath):
    try:
        with open(filePath, 'r') as json_file:
            return json.load(json_file)
    except:
        pass
    return {}

def run_file_check(confDir='conf', fname='config.json'):
    def _chk_json(loaded):
        try:
            return headers_check(**loaded) and loaded
        except NameError:
            syslog.syslog(syslog.LOG_ERR, 'Issue loading config. Check the state of config.')
            return False
    return _chk_json(open_json(os.path.join(os.path.dirname(__file__), confDir, fname)))

def frequency_integer_guard(curr_val, min_guard_val, max_guard_value):
    if curr_val < min_guard_val or curr_val > max_guard_value:
        syslog.syslog(syslog.LOG_ERR, 'Current frequency value is either too high or too low.')
        return False
    return True

def method_sanity_check(*valid_methods, method):
    meth_arr = []
    for methods in valid_methods:
        meth_arr.append(methods)
    if method.upper() not in [x.upper() for x in meth_arr]:
        syslog.syslog(syslog.LOG_ERR, 'Not a valid method.')
        return False
    return True

def time_formatter_and_data_writer(arr, *columns):
    event_messages = []
    if arr == None:
        syslog.syslog(syslog.LOG_ERR, "Data set is most definitely empty, stopping here.")
        SystemExit(0)
    for dictionary in arr:
        message_attributes = []
        for k,v in dictionary.items():
            if v == None: continue
            try:
                if k in [x for x in columns]:
                    num = int(v.strip('/Date(').strip(')/'))
                    v = time.strftime('%Y-%m-%d %H:%M:%S', time.gmtime(num/1000.0))
            except Exception as e:
                syslog.syslog(syslog.LOG_ERR, f'Major issue formatting data. Please review the config and query. Exception: {e}')
                return False
            message_attributes.append(f'[{k}] = {v}')
        if  len(message_attributes) > 0:
            event_messages.append(", ".join(message_attributes))
    return event_messages #", ".join(event_messages)

def init_file_utils(loaded=run_file_check()):
    return {
        "loaded": loaded
    }

if __name__ == "__main__":
    init_file_utils()
